#!/usr/bin/python3

import util
import fasta

def main():
    start = dict()
    stop  = dict()

    state = 0

    for e in util.trainingData:
        dna = fasta.read(e[0])
        ann = fasta.read(e[1])

        state = 0

        for i in range(0, len(dna)-1):
            if state == 0 and ann[i] == 'C':
                s = dna[i:i+3]
                if not s in start:
                    start[s] = 1
                else:
                    start[s] += 1

                print("START ANN:", ann[i-1:i+3])
                print("DNA:", "'" + s + "'")

                state = 1
            elif state == 1 and ann[i] == 'N':
                s = dna[i-3:i]

                if s not in stop:
                    stop[s] = 1
                else:
                    stop[s] += 1

                print("STOP ANN:", ann[i-3:i+1])
                print("DNA:", "'" + s + "'")

                state = 0


        #break


    print("Starting Codons")
    for k, v in start.items():
        print("\t{0}: {1}".format(k, v))

    print("Stopping Codons")
    for k, v in stop.items():
        print("\t{0}: {1}".format(k, v))

if __name__ == '__main__':
    main()
