#!/usr/bin/python3

import os
import time
import numpy
import csv
import sys
import util
import viterbi
import train
import HMM
import socket
import json
import urllib.request

def run(hmm, files, docache = False):
    print('= Viterbi')
    print('  -> Predict')

    #if not os.path.isfile('cache/w.save'):
    #    w = viterbi.predict(hmm, files[0])
    #    
    #    numpy.savetxt('cache/w.save', w)
    #else:
    #    w = numpy.loadtxt('cache/w.save')
    w = viterbi.predict(hmm, files[0])

    print('  -> Backtrack')
    #if not os.path.isfile('cache/z.save'):
    #    z = viterbi.backtrack(hmm, files[0], w)

    #    numpy.savetxt('cache/z.save', z)
    #else:
    #    z = numpy.loadtxt('cache/z.save')

    z = viterbi.backtrack(hmm, files[0], w)

    return z

def ann(hmm, z, outputfile):
    ann = dict()
    res = ''

    for k, v in hmm["states"].items():
        ann[v['i']] = v['a']

    for n in z:
        res += ann[n] 

    f = open(outputfile, 'w')
    f.write(">Annotation generated by dat7 on {0}".format(time.strftime("%Y/%m/%d - %H:%M:%S\n")))

    i = 0
    while i < len(res):
        end = min(i+60, len(res))
        f.write(res[i:end] + "\n")
        i+=60

    f.close()

def monitor(iteration, max_iterations, description):
    global json

    params = json.dumps({
        'machine' : socket.gethostname(),
        'iteration' : iteration,
        'iteration_max' : max_iterations,
        'description' : description 
    }).encode('utf-8')
    req = urllib.request.Request(
        'http://dat7.dk/io-cluster/',
        data=params,
        headers={'content-type': 'application/json'}
    )
    urllib.request.urlopen(req)

def main(argv):
    monitor(1, 1, "Fetching JSON model and creating HMM")
    time.sleep(1)
    
    #    if not os.path.isfile('cache/hmm.save'):
    (inputfile, outputfile, model, cross, dot) = util.parseOpts(argv)

    json = HMM.readJsonFile(model)
    hmm  = HMM.createHMM(json)

    if dot:
        #tpl = (inputfile, dict(util.trainingData)[inputfile])
        #train.trainByCounting(hmm, tpl)
        HMM.toDot(hmm, model.replace(".json", ".png"))
        train.trainByCounting(hmm, util.trainingData[0])
        train.trainByCounting(hmm, util.trainingData[1])
        train.trainByCounting(hmm, util.trainingData[2])
        train.trainByCounting(hmm, util.trainingData[3])
        train.trainByCounting(hmm, util.trainingData[4])
        train.normalize(hmm)

        HMM.toDot(hmm, model.replace(".json", ".png"))
        sys.exit(0)

    if cross:
        i = 0
        while i < len(util.trainingData): 
            monitor(i+1, len(util.trainingData), "Cross-fold validation")
            j = 0
            for k in util.trainingData:
                if i == j:
                    j += 1
                    continue
                j += 1
                train.trainByCounting(hmm, k)

            train.normalize(hmm)
            z = run(hmm, util.trainingData[i])
            ann(hmm, z, 'predictions/' + 
                    (util.trainingData[i][1]).replace("annotations/", ""))

            i += 1

        monitor(1, 1, "Done")
    else:
        tpl = (inputfile, dict(util.trainingData)[inputfile])
        #train.trainByCounting(hmm, tpl)
        train.trainByCounting(hmm, util.trainingData[1])
        train.trainByCounting(hmm, util.trainingData[2])
        train.trainByCounting(hmm, util.trainingData[3])
        train.trainByCounting(hmm, util.trainingData[4])
        train.normalize(hmm)
        HMM.toDot(hmm, model.replace(".json", ".png"))
        z = run(hmm, tpl)
        ann(hmm, z, outputfile)
    

if __name__ != "__main__":
    print('main.py is not supposed to be imported')
    sys.exit(1)

if len(sys.argv) <= 1:
    print('main.py -m <model> -i <inputfile> -o <outputfile> -c <crossvalidation>')
    sys.exit(1)

main(sys.argv[1:])
