function [theta_l, cost_l] = softRun(X, Y, theta)
	% The learning rate
	lr = 0.1;
	X = [ones(size(X,1),1) X];
	theta = [zeros(1, size(theta, 2)); theta];

	% Amount of iterations
	max_iter = 150;

	theta_l = nan(size(theta,1), size(theta, 2), max_iter);
	cost_l = nan(max_iter, 1);
	theta_l(:,:,1) = theta;

	for i=2:max_iter+1
		[cost_l(i-1), grad] = softCost(X, Y, squeeze(theta_l(:,:,i-1)));

		% Notice: We are adding the gradient, not subtracting it.
		theta_l(:,:,i) = (squeeze(theta_l(:,:,i-1)) + lr*grad);
	end

	[cost_l(end), ignore] = softCost(X, Y, squeeze(theta_l(:,:,end)));
end
