%% Kig i week_1_2.pdf slide 37.
function [theta_l, cost_l] = logRun(X, y, theta)
	% The learning rate
	lr = 0.1;
	X = [ones(size(X,1),1) X];
	theta = [0; theta];

	% Amount of iterations
	max_iter = 150;

	theta_l = nan(max_iter, length(theta));
	cost_l = nan(max_iter, 1);
	theta_l(1, :) = theta;

	for i=2:max_iter+1
		[cost_l(i-1), grad] = logCost(X, y, theta_l(i-1, :)');

		% Notice: We are adding the gradient, not subtracting it.
		theta_l(i, :) = (theta_l(i-1, :)' + lr*grad);
	end

	[cost_l(end), ignore] = logCost(X, y, theta_l(end, :)');

	%f = figure();
	%ax2 = axes('parent',f);
	%hold(ax2,'on');
	%for i=1:length(cost_l)
	%	%plot(ax1,theta_l(i,1),theta_l(i,2),'wx','markersize',8,'linewidth',3);    
	%	plot(ax2,i,cost_l(i),'bx','markersize',8,'linewidth',3);
	%	input('next point','s');
	%end
end
