function [cost, grad] = logCost(X, y, theta)

	%XTheta = (theta' * X')';
	XTheta = X*theta;
	sigmaXTheta = sigma(XTheta);

	first = y .* log(sigmaXTheta);
	second = (1 - y) .* log(1 - sigmaXTheta);

	cost = -sum((first + second));

	grad = X' * (y - sigmaXTheta);

	grad = grad./norm(grad, 2);
end

function [val] = sigma_book(z)
	z;
	val = exp(z)./(1 + exp(z));
end

function [val] = sigma(z)
	z;
	val = 1./(1 + exp(-z));
end
