#include <stdint.h>
#include <gmp.h>

#ifndef STREAMS
#define STREAMS

typedef void (*writer_t)(int i, uint32_t v);
typedef void (*closer_t)(int i);
typedef uint32_t (*reader_t)(int i);
typedef int (*eoser_t)(int i);

typedef int (*opener_t)(char *f, uint64_t start, uint64_t length);
typedef int (*creater_t)(char *f, uint64_t start, uint64_t length);

typedef struct {
	reader_t next;
	eoser_t  eos;
	closer_t close;
	opener_t open;
} in_stream;

typedef struct {
	writer_t  write;
	closer_t  close;
	creater_t create;
} out_stream;

// Memory allocation functions.
void *xcalloc(size_t nmemb, size_t size);
void *xmalloc(size_t size);
void *xrealloc(void *ptr, size_t size);

// Implementation of part A using read() and write() system calls.
int i_open(const char *f, uint64_t start, uint64_t length);
uint32_t i_next(int id);
int i_eos(int id);
void i_close(int id);

int o_create(const char *f, uint64_t start);
void o_write(int od, uint32_t v);
void o_close(int od);

// Implementation of part B using fread() and fwrite() library calls.
int fi_open(const char *f, uint64_t start, uint64_t length);
uint32_t fi_next(int id);
int fi_eos(int id);
void fi_close(int id);

int fo_create(const char *f, uint64_t start);
void fo_write(int od, uint32_t v);
void fo_close(int od);

// Implementation of part C using part A with buffers.
int bi_open(const char *f, uint64_t start, uint64_t length, int B);
uint32_t bi_next(int id);
int bi_eos(int id);
void bi_close(int id);

int bo_create(const char *f, uint64_t start, int B);
void bo_write(int od, uint32_t v);
void bo_close(int od);

// Implementation of part D using mmap.
int mi_open(const char *f, uint64_t start, uint64_t length, int B);
uint32_t mi_next(int id);
int mi_eos(int id);
void mi_close(int id);

int mo_create(const char *f, uint64_t start, uint64_t length, int B);
void mo_write(int od, uint32_t v);
void mo_close(int od);

#endif
