#!/usr/bin/env bash
REPEAT_COUNT=5
RESULTS_FOLDER=RESULTS

declare -a COMMANDS=(
	"./memlock quicksort -i ../TEST1 -B 4194304 >> RESULTS/1.csv"
	"./memlock quicksort -i ../TEST2 -B 4194304 >> RESULTS/2.csv"
	"./memlock quicksort -i ../TEST3 -B 4194304 >> RESULTS/3.csv"
	"./memlock quicksort -i ../TEST4 -B 4194304 >> RESULTS/4.csv"
	);

trap "tput cvvis; echo \"\"; exit" SIGINT

function clearCaches() {
	if [[ ${UID} -eq 0 ]]; then
		echo 3 > /proc/sys/vm/drop_caches
		blockdev --flushbufs /dev/sda
		sync
	fi
}

function clearTmp() {
	rm -f sorted.out
}

mkdir -p ${RESULTS_FOLDER}

for c in "${COMMANDS[@]}"; do
	for r in `seq 1 ${REPEAT_COUNT}`; do
		clearCaches
		clearTmp
		eval $c;
	done
done
