#include <sys/queue.h>
// Returns the filesize of file, exits the entire program on error.
uint64_t filesize(char *file);

void *xcalloc(size_t nmemb, size_t size);
void *xmalloc(size_t size);
void *xrealloc(void *ptr, size_t size);

int intcmp(const void *a, const void *b);
void removefile(char *f);

struct entry {
	int fd;
	int size;
	char *filename;
	TAILQ_ENTRY(entry) entries;
};

typedef struct entry entry_t;

void mergesort(char *input, char *output, in_stream *in, out_stream *out, uint64_t N, unsigned int M, unsigned int d);

struct tailqhead *sortfile(char *input, char *output, in_stream *in, out_stream *out, uint64_t N, unsigned int M);
char *merge_streams(in_stream *in, out_stream *out, unsigned int d, struct tailqhead *head);

int open_output_stream(char *f, uint64_t start, uint64_t length);
int open_input_stream(char *f, uint64_t start, uint64_t length);
