#define _DEFAULT_SOURCE
#define _GNU_SOURCE

#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <time.h>
#include <getopt.h>
#include <sys/resource.h>

// For stat()
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <streams.h>
#include "hsort.h"
//#include "heap.h"

//int min_heap_comparer(uint32_t a, uint32_t b) {
//	return a < b;
//}

uint64_t filesize(char *file) {
	struct stat buf;
	int r = stat(file, &buf);
	if (r == -1) {
		fprintf(stderr, "Cannot stat '%s': '%s'\n", file, strerror(errno));
		exit(EXIT_FAILURE);
	}

	return buf.st_size;
}

void *xmalloc(size_t size) {
	void *p = malloc(size);

	if (p == NULL) {
		fprintf(stderr, "Unable to m-allocate memory.\n");
		exit(EXIT_FAILURE);
	}

	return p;
}

void printusage(char *argv[]) {
	fprintf(stderr, "Usage: %s \n"
			"\t[-N #samples]\n"
			"\t[-B buffer size]\n"
			"\t[-i input file]\n"
			, argv[0]);
}


int main(int argc, char *argv[]) {
	char *input  = "../BIGFILE";
	char *output = "sorted.out";

	struct timespec begin;
	struct timespec end;
	int opt;
	int total_ns;
	int total_s;
	struct rusage usage;

	int BUFFER = 1024;
	uint64_t N = 0;

	while ((opt = getopt(argc, argv, "N:B:i:")) != -1) {
		switch (opt) {
		case 'N':
			N = strtoull(optarg, NULL, 10);
			break;
		case 'B':
			BUFFER = strtol(optarg, NULL, 10);
			break;
		case 'i':
			input = strndup(optarg, 200);
			break;
		default:
			printusage(argv);
			exit(EXIT_FAILURE);
		}
	}

	if (N == 0) {
		N = filesize(input);
	}

	uint64_t elements = N/sizeof(uint32_t);

	clock_gettime(CLOCK_REALTIME, &begin);

	uint64_t p = 0;
//	uint32_t q = 0;
	uint32_t *storage = xmalloc(N);
	int ifd = bi_open(input, 0, elements, BUFFER);

	while (bi_eos(ifd) == 0) {
		storage[p] = bi_next(ifd);
		p++;
	}

	bi_close(ifd);

//	struct heap h;

	heapsort(storage, 0, elements-1);
//	heapify(storage, elements, min_heap_comparer);
//
//	heap_init(&h, min_heap_comparer);

//	free(h.data);
//	h.size = N;
//	h.data = storage;
//	h.count = elements;

	int ofd = bo_create(output, 0, BUFFER);

//	while (h.count > 0) {
//		q = (uint32_t)heap_front(&h);
//		bo_write(ofd, q);
//
//		heap_pop(&h);
//	}

	for (p = 0; p < elements; p++) {
		bo_write(ofd, storage[p]);
	}

	free(storage);

	bo_close(ofd);

//	heap_term(&h);

	getrusage(RUSAGE_THREAD, &usage);
	clock_gettime(CLOCK_REALTIME, &end);

	if (begin.tv_nsec <= end.tv_nsec) {
		total_ns = end.tv_nsec - begin.tv_nsec;
		total_s  = end.tv_sec  - begin.tv_sec;
	} else {
		total_ns = end.tv_nsec + (1e9 - begin.tv_nsec);
		total_s  = end.tv_sec - begin.tv_sec - 1;
	}

	printf(
		"%d,%d,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld\n",
			/* Total realworld seconds/nsec used */
			total_s,
			total_ns,
			/* Total amount of CPU user time used.  */
			usage.ru_utime.tv_sec,   // Seconds
			usage.ru_utime.tv_usec,  // Microseconds
			/* Total amount of CPU system time used.  */
			usage.ru_stime.tv_sec,   // Seconds
			usage.ru_stime.tv_usec,  // Microseconds
			/* Maximum resident set size (in kilobytes).  */
			usage.ru_maxrss,
			/* Amount of data segment memory used (kilobyte-seconds).  */
			usage.ru_idrss,
			/* Amount of stack memory used (kilobyte-seconds).  */
			usage.ru_isrss,
			/* Number of soft page faults (i.e. those serviced by reclaiming
			   a page from the list of pages awaiting reallocation.  */
			usage.ru_minflt,
			/* Number of hard page faults (i.e. those that required I/O).  */
			usage.ru_majflt,
			/* Number of times a process was swapped out of physical memory. */
			usage.ru_nswap,
			/* Number of input operations via the file system.  Note: This
			   and `ru_oublock' do not include operations with the cache.  */
			usage.ru_inblock,
			/* Number of output operations via the file system.  */
			usage.ru_oublock,
			/* Number of voluntary context switches, i.e. because the process
			   gave up the process before it had to (usually to wait for some
			   resource to be available).  */
			usage.ru_nvcsw,
			/* Number of involuntary context switches, i.e. a higher priority
			 * process became runnable or the current process used up its time
			 * slice. */
			usage.ru_nivcsw
		);

	return EXIT_SUCCESS;
}
