// Borrowed from: http://www.cs.princeton.edu/~rs/Algs3.c1-4/code.txt

#include <stdint.h>

#include "hsort.h"

void fixDown(Item a[], uint64_t k, uint64_t N) {
	uint64_t j;
    while (2*k <= N) {
		j = 2*k;

        if ( j < N && less(a[j], a[j+1]) ) {
			j++;
		}

        if ( !less(a[k], a[j]) ) {
			break;
		}

        exch(a[k], a[j]);
		k = j;
	}
}

void heapsort(Item a[], uint64_t l, uint64_t r) {
	uint64_t k, N = r-l+1;
	for (k = N/2; k >= 1; k--) {
		fixDown(&pq(0), k, N);
	}

	while (N > 1) {
		exch(pq(1), pq(N)); 
		fixDown(&pq(0), 1, --N);
	}
}
