// Origin: https://gist.github.com/martinkunev/1365481/

// WARNING: Requires C99 compatible compiler

#include <stdint.h>

typedef uint32_t type;
typedef int (*heap_compare_t)(type a, type b);

struct heap
{
	uint64_t size; // Size of the allocated memory (in number of items)
	uint64_t count; // Count of the elements in the heap
	type *data; // Array with the elements
	heap_compare_t cmp; // Compare function
};

void heap_init(struct heap *restrict h, heap_compare_t cmp);
void heap_push(struct heap *restrict h, type value);
void heap_pop(struct heap *restrict h);

// Returns the biggest element in the heap
#define heap_front(h) (*(h)->data)

// Frees the allocated memory
#define heap_term(h) (free((h)->data))

void heapify(type data[restrict], uint64_t count, heap_compare_t cmp);
