#include <stdlib.h>
#include <stdio.h>
#include <streams.h>
#include <stdint.h>
#include "dmerge.h"
#include "heap.h"

typedef struct {
	uint32_t el;
	int stream_i;
} el_t;

int min_heap_comparer(uintptr_t a, uintptr_t b) {
	el_t *elA = (el_t *)a;
	el_t *elB = (el_t *)b;

	return elA->el < elB->el;
}

int dmerge(int d, in_stream *in, int *ifds, out_stream *out, int ofd) {
	int i, size = 0;
	struct heap hipster_heap;
	el_t *el;

	// Init heap
	heap_init(&hipster_heap, min_heap_comparer);

	// Fetch the first elements into the heap
	for (i = 0; i < d; i++) {
		if (in->eos(ifds[i]) == 0) {
			el = malloc(sizeof(el_t));
			el->el = in->next(ifds[i]);
			el->stream_i = i;

			heap_push(&hipster_heap, (uintptr_t)el);
		}
	}

	// Merge
	while (hipster_heap.count > 0) {
		el = (el_t *)heap_front(&hipster_heap);

		heap_pop(&hipster_heap);

		out->write(ofd, el->el);
		size++;

		if (in->eos(ifds[el->stream_i]) == 0) {
			el->el = in->next(ifds[el->stream_i]);

			heap_push(&hipster_heap, (uintptr_t)el);
		} else {
			free(el);
		}
	}

	// Terminate heap
	heap_term(&hipster_heap);

	return size;
}
