RESULTS_FOLDER=RESULTS_MISSING_TESTS

declare -a COMMANDS=(
	"./mergesort -i TEST4 -M 52428800 -B 1048576 -d 3  >> ${RESULTS_FOLDER}/4.3.52428800.csv"
	"./mergesort -i TEST4 -M 89128960 -B 1048576 -d 3  >> ${RESULTS_FOLDER}/4.3.89128960.csv"
	"./mergesort -i TEST4 -M 52428800 -B 1048576 -d 9  >> ${RESULTS_FOLDER}/4.9.52428800.csv"
	"./mergesort -i TEST4 -M 89128960 -B 1048576 -d 9  >> ${RESULTS_FOLDER}/4.9.89128960.csv"
	"./mergesort -i TEST4 -M 52428800 -B 1048576 -d 17 >> ${RESULTS_FOLDER}/4.17.52428800.csv"
	"./mergesort -i TEST4 -M 89128960 -B 1048576 -d 17 >> ${RESULTS_FOLDER}/4.17.89128960.csv"
);

trap "tput cvvis; echo \"\"; exit" SIGINT

function clearCaches() {
	if [[ ${UID} -eq 0 ]]; then
		echo 3 > /proc/sys/vm/drop_caches
		blockdev --flushbufs /dev/sda
		sync
	fi
}

mkdir -p ${RESULTS_FOLDER}

REPETITION=0
for r in `seq 1 ${REPEAT_COUNT}`; do
	REPETITION=$(( ${REPETITION} + 1 ))

	for c in "${COMMANDS[@]}"; do
		echo $c;
		clearCaches
		eval $c;
	done
done

