#!/usr/bin/env bash
EXE=./mergesort
REPEAT_COUNT=3   # Times we repeat each test
TESTMAX=1        # Maximal number of tests
RESULTS_FOLDER=BENCHMARK_RESULTS
TMP_FOLDER=tmp

DEBUG="0"

# TODO:
# - Check if buffer size is above write/read size?
# - Switch around repetitions, so they are outside.

REPETITION=0
TEST=0

MEMLIMIT=0
MEMLOAD=0

DISKLIMIT=0
DISKLOAD=0

# Don't allow memory usage over 1GiB
MEMLIMIT=$(( 1024 * 1024 * 1024 * 4 ))

# Don't allow disk usage over 4GiB
DISKLIMIT=$(( 1024*1024*4096 ))

# Files to use
declare -a irange=("TEST4")

# The buffer size, per thread.
# 4 MiB
declare -a Brange=(1048576)

# The memory size
declare -a Mrange=(89128960)

# Amount of writers/readers to use.
declare -a drange=(121)

# The streams to use
declare -a Srange=(3) 

# Do both write/read test.
declare -a trange=('w' 'r')

trap "tput cvvis; echo \"\"; exit" SIGINT

function clearCaches() {
	if [[ ${UID} -eq 0 ]]; then
		echo 3 > /proc/sys/vm/drop_caches
		blockdev --flushbufs /dev/sda
		sync
	fi
}

function clearTmp() {
	# Delete files on run, if we are writing.
	if [[ ${DEBUG} != "1" ]]; then
		rm -f ${TMP_FOLDER}/file*
	fi
}

function performTest() {
	local d=$1 # open files
	local S=$2 # Stream type
	local i=$3 # Test file
	local M=$4 # Test file
	local B=$5 # Buffer size, in uint32_t

	# Clear the lines for output
	echo -en "\r"
	tput el
	tput cuu1
	echo -en "\r"
	tput el

	echo "Performing iteration ${REPETITION}/${REPEAT_COUNT} of test ${TEST}/${TESTMAX}"
	printf "i: %s S: %d  d: %4d  M: %d  B: %8d" $i $S $d $M $B

	# Where we save our data.
	OUTFILE=""

	# Specify the B parameter
	if [[ -n ${B} || ${B} != "" ]]; then
		OUTFILE="${RESULTS_FOLDER}/${i}.${S}.${d}.${M}.${B}.csv"
		B="-B ${B}"
	else
		B=""
		OUTFILE="${RESULTS_FOLDER}/${i}.${S}.${M}.${d}.csv"
	fi

	if [[ ${DEBUG} != "1" ]]; then
		${EXE} -S ${S} -i ${i} -d ${d} -M ${M} ${B} >> ${OUTFILE};
	else
		sleep 0.5
	fi
}

function runUnbuffered() {
	local d=$1
	local S=$2
	local i=$3
	local M=$4

	TEST=$(( ${TEST} + 1 ))

	clearTmp
	performTest $d $S $i $M
	clearCaches
}

function runBuffered() {
	local d=$1
	local S=$2
	local i=$3
	local M=$4

	for B in ${Brange[@]}; do
		MEMLOAD=$(( ${d} * ${B} * 4 ))	

		if [[ ${MEMLOAD} -lt ${MEMLIMIT} ]]; then
			TEST=$(( ${TEST} + 1 ))

			clearTmp
			performTest $d $S $i $M $B
			clearCaches
		fi
	done
}


tput civis
mkdir -p ${RESULTS_FOLDER}

echo ""

REPETITION=0
for r in `seq 1 ${REPEAT_COUNT}`; do
	REPETITION=$(( ${REPETITION} + 1 ))
	TEST=0

	for d in ${drange[@]}; do
		for S in ${Srange[@]}; do
			for M in ${Mrange[@]}; do
				for i in ${irange[@]}; do
					if [[ ${S} -eq 1 || ${S} -eq 2 ]]; then
						runUnbuffered ${d} ${S} ${i} ${M}
					else
						runBuffered ${d} ${S} ${i} ${M}
					fi
				done
			done
		done
	done
done

tput cvvis
echo ""


