#!/usr/bin/env bash
#EXE=./TestStream
#REPEAT_COUNT=20  # Times we repeat each test
#TESTMAX=2140    # Maximal number of tests
RESULTS_FOLDER=RESULTS
#TMP_FOLDER=tmp

#DEBUG="1"

# TODO:
# - Check if buffer size is above write/read size?
# - Switch around repetitions, so they are outside.

#REPETITION=0
#TEST=0

#MEMLIMIT=0
#MEMLOAD=0

#DISKLIMIT=0
#DISKLOAD=0

# 50M = 52428800
# 95M = 99614720

declare -a COMMANDS=(
	"./mergesort -i TEST1 -M 52428800 -d 2 >> RESULTS/1.2.52428800.csv"
	"./mergesort -i TEST1 -M 99614720 -d 2  >> RESULTS/1.2.99614720.csv"
	"./mergesort -i TEST1 -M 52428800 -d 3  >> RESULTS/1.3.52428800.csv"
	"./mergesort -i TEST1 -M 99614720 -d 3  >> RESULTS/1.3.99614720.csv"
	"./mergesort -i TEST1 -M 52428800 -d 5  >> RESULTS/1.5.52428800.csv"
	"./mergesort -i TEST1 -M 99614720 -d 5  >> RESULTS/1.5.99614720.csv"
	"./mergesort -i TEST1 -M 52428800 -d 9  >> RESULTS/1.9.52428800.csv"
	"./mergesort -i TEST1 -M 99614720 -d 9  >> RESULTS/1.9.99614720.csv"
	"./mergesort -i TEST1 -M 52428800 -d 13 >> RESULTS/1.13.52428800.csv"
	"./mergesort -i TEST1 -M 99614720 -d 13 >> RESULTS/1.13.99614720.csv"
	"./mergesort -i TEST1 -M 52428800 -d 17 >> RESULTS/1.17.52428800.csv"
	"./mergesort -i TEST1 -M 99614720 -d 17 >> RESULTS/1.17.99614720.csv"
	"./mergesort -i TEST1 -M 52428800 -d 21 >> RESULTS/1.21.52428800.csv"
	"./mergesort -i TEST1 -M 99614720 -d 21 >> RESULTS/1.21.99614720.csv"

	"./mergesort -i TEST2 -M 52428800 -d 2  >> RESULTS/2.2.52428800.csv"
	"./mergesort -i TEST2 -M 99614720 -d 2  >> RESULTS/2.2.99614720.csv"
	"./mergesort -i TEST2 -M 52428800 -d 3  >> RESULTS/2.3.52428800.csv"
	"./mergesort -i TEST2 -M 99614720 -d 3  >> RESULTS/2.3.99614720.csv"
	"./mergesort -i TEST2 -M 52428800 -d 5  >> RESULTS/2.5.52428800.csv"
	"./mergesort -i TEST2 -M 99614720 -d 5  >> RESULTS/2.5.99614720.csv"
	"./mergesort -i TEST2 -M 52428800 -d 9  >> RESULTS/2.9.52428800.csv"
	"./mergesort -i TEST2 -M 99614720 -d 9  >> RESULTS/2.9.99614720.csv"
	"./mergesort -i TEST2 -M 52428800 -d 13 >> RESULTS/2.13.52428800.csv"
	"./mergesort -i TEST2 -M 99614720 -d 13 >> RESULTS/2.13.99614720.csv"
	"./mergesort -i TEST2 -M 52428800 -d 17 >> RESULTS/2.17.52428800.csv"
	"./mergesort -i TEST2 -M 99614720 -d 17 >> RESULTS/2.17.99614720.csv"
	"./mergesort -i TEST2 -M 52428800 -d 21 >> RESULTS/2.21.52428800.csv"
	"./mergesort -i TEST2 -M 99614720 -d 21 >> RESULTS/2.21.99614720.csv"

	"./mergesort -i TEST3 -M 52428800 -d 2  >> RESULTS/3.2.52428800.csv"
	"./mergesort -i TEST3 -M 99614720 -d 2  >> RESULTS/3.2.99614720.csv"
	"./mergesort -i TEST3 -M 52428800 -d 3  >> RESULTS/3.3.52428800.csv"
	"./mergesort -i TEST3 -M 99614720 -d 3  >> RESULTS/3.3.99614720.csv"
	"./mergesort -i TEST3 -M 52428800 -d 5  >> RESULTS/3.5.52428800.csv"
	"./mergesort -i TEST3 -M 99614720 -d 5  >> RESULTS/3.5.99614720.csv"
	"./mergesort -i TEST3 -M 52428800 -d 9  >> RESULTS/3.9.52428800.csv"
	"./mergesort -i TEST3 -M 99614720 -d 9  >> RESULTS/3.9.99614720.csv"
	"./mergesort -i TEST3 -M 52428800 -d 13 >> RESULTS/3.13.52428800.csv"
	"./mergesort -i TEST3 -M 99614720 -d 13 >> RESULTS/3.13.99614720.csv"
	"./mergesort -i TEST3 -M 52428800 -d 17 >> RESULTS/3.17.52428800.csv"
	"./mergesort -i TEST3 -M 99614720 -d 17 >> RESULTS/3.17.99614720.csv"
	"./mergesort -i TEST3 -M 52428800 -d 21 >> RESULTS/3.21.52428800.csv"
	"./mergesort -i TEST3 -M 99614720 -d 21 >> RESULTS/3.21.99614720.csv"

	"./mergesort -i TEST4 -M 52428800 -d 2  >> RESULTS/4.2.52428800.csv"
	"./mergesort -i TEST4 -M 99614720 -d 2  >> RESULTS/4.2.99614720.csv"
	"./mergesort -i TEST4 -M 52428800 -d 3  >> RESULTS/4.3.52428800.csv"
	"./mergesort -i TEST4 -M 99614720 -d 3  >> RESULTS/4.3.99614720.csv"
	"./mergesort -i TEST4 -M 52428800 -d 5  >> RESULTS/4.5.52428800.csv"
	"./mergesort -i TEST4 -M 99614720 -d 5  >> RESULTS/4.5.99614720.csv"
	"./mergesort -i TEST4 -M 52428800 -d 9  >> RESULTS/4.9.52428800.csv"
	"./mergesort -i TEST4 -M 99614720 -d 9  >> RESULTS/4.9.99614720.csv"
	"./mergesort -i TEST4 -M 52428800 -d 13 >> RESULTS/4.13.52428800.csv"
	"./mergesort -i TEST4 -M 99614720 -d 13 >> RESULTS/4.13.99614720.csv"
	"./mergesort -i TEST4 -M 52428800 -d 17 >> RESULTS/4.17.52428800.csv"
	"./mergesort -i TEST4 -M 99614720 -d 17 >> RESULTS/4.17.99614720.csv"
	"./mergesort -i TEST4 -M 52428800 -d 21 >> RESULTS/4.21.52428800.csv"
	"./mergesort -i TEST4 -M 99614720 -d 21 >> RESULTS/4.21.99614720.csv"

	);

trap "tput cvvis; echo \"\"; exit" SIGINT

function clearCaches() {
	if [[ ${UID} -eq 0 ]]; then
		echo 3 > /proc/sys/vm/drop_caches
		blockdev --flushbufs /dev/sda
		sync
	fi
}

function clearTmp() {
	rm sorted.out
}

#function performTest() {
#	local N=$1 # Output/input size in uint32_t
#	local k=$2 # open files
#	local S=$3 # Stream type
#	local t=$4 # Test type (read/write)
#	local B=$5 # Buffer size, in uint32_t
#
#	# Clear the lines for output
#	echo -en "\r"
#	tput el
#	tput cuu1
#	echo -en "\r"
#	tput el
#
#	echo "Performing iteration ${REPETITION}/${REPEAT_COUNT} of test ${TEST}/${TESTMAX}"
#	printf "t: %s  S: %d  k: %4d  N: %8d  B: %8d" $t $S $k $N $B
#
#	# Where we save our data.
#	OUTFILE=""
#
#	# Specify the B parameter
#	if [[ -n ${B} || ${B} != "" ]]; then
#		OUTFILE="${RESULTS_FOLDER}/${S}.${t}.${k}.${N}.${B}.csv"
#		B="-B ${B}"
#	else
#		B=""
#		OUTFILE="${RESULTS_FOLDER}/${S}.${t}.${k}.${N}.csv"
#	fi
#
#	if [[ ${DEBUG} != "1" ]]; then
#		${EXE} -D ${TMP_FOLDER} -S ${S} -N ${N} -t ${t} ${B} -k ${k} >> ${OUTFILE};
#	else
#		sleep 0.5
#	fi
#}
#
#function runUnbuffered() {
#	local N=$1
#	local k=$2
#	local S=$3
#
#	for t in ${trange[@]}; do
#		DISKLOAD=$(( ${k} * ${N} * 4 ))
#
#		if [[ ${DISKLOAD} -lt ${DISKLIMIT} ]]; then
#			TEST=$(( ${TEST} + 1 ))
#
#			clearTmp ${t}
#			performTest $N $k $S $t
#			clearCaches
#
#			# Delete files after we've read for the last time.
#			if [[ ${t} == "r" ]]; then
#				if [[ ${DEBUG} != "1" ]]; then
#					rm -f ${TMP_FOLDER}/file*
#				fi
#			fi
#		fi
#	done
#}
#
#function runBuffered() {
#	local N=$1
#	local k=$2
#	local S=$3
#
#	for B in ${Brange[@]}; do
#		for t in ${trange[@]}; do
#			MEMLOAD=$(( ${k} * ${B} * 4 ))	
#			DISKLOAD=$(( ${k} * ${N} * 4 ))
#
#			if [[ ${MEMLOAD} -lt ${MEMLIMIT} &&  ${DISKLOAD} -lt ${DISKLIMIT} ]]; then
#				TEST=$(( ${TEST} + 1 ))
#
#
#				clearTmp ${t}
#				performTest $N $k $S $t $B
#				clearCaches
#
#				# Delete files after we've read for the last time.
#				if [[ ${t} == "r" ]]; then
#					if [[ ${DEBUG} != "1" ]]; then
#						rm -f ${TMP_FOLDER}/file*
#					fi
#				fi
#			fi
#		done
#	done
#}

#LEN=$(( ${#Nrange[@]} * ${#Brange[@]} * ${#krange[@]} * ${#Srange[@]} * ${#trange[@]} ))
#echo $LEN

#tput civis
mkdir -p ${RESULTS_FOLDER}

#echo ""

REPETITION=0
for r in `seq 1 ${REPEAT_COUNT}`; do
	REPETITION=$(( ${REPETITION} + 1 ))

	for c in "${COMMANDS[@]}"; do
		clearCaches
		clearTmp
		eval $c;
	done
done

#tput cvvis
#echo ""
