#ifndef H_sankowski
#define H_sankowski

#define SEED 1337

#include <inttypes.h>
#include <stdbool.h>

#include "matrix.h" 

typedef struct {
	// Adjacency matrix
	matrix_t *B;

	// (I-B)^{-1}
	matrix_t *C;

	// Row vector
	matrix_t *rv;

	// Column vector
	matrix_t *cv;

	// Count of transitive closures
	uint32_t tc;

	// Amount of vertices in graph 
	uint32_t n;
} sankowski_t;

sankowski_t *sankowski_init(uint32_t n);

void sankowski_destroy(sankowski_t *s);
void sankowski_insert(sankowski_t *s, uint32_t i, uint32_t j);
void sankowski_delete(sankowski_t *s, uint32_t i, uint32_t j);

void sankowski_remove(sankowski_t *s, uint32_t idx, bool fast);
void sankowski_expand(sankowski_t *s);

uint32_t sankowski_query(sankowski_t *s);

#endif
