#ifndef BITMATRIXH
#define BITMATRIXH

#include <inttypes.h>

#define BPI (uint64_t)(8 * sizeof(uint64_t))

typedef struct{
	uint64_t *data;
	uint32_t m, n;
	uint32_t size, rsize;
} bitmatrix_t;

bitmatrix_t *bitmatrix_create(uint32_t m, uint32_t n);
void bitmatrix_zero(bitmatrix_t *m);

void bitmatrix_setbit(bitmatrix_t *m, uint32_t i, uint32_t j);
void bitmatrix_clearbit(bitmatrix_t *m, uint32_t i, uint32_t j);
void bitmatrix_print(bitmatrix_t *m);
void bitmatrix_destroy(bitmatrix_t *m);
void bitmatrix_identity(bitmatrix_t *m);

#endif
