#ifndef H_XUTIL
#define H_XUTIL

// Terminal colors
#define KNRM  "\x1B[0m"
#define KRED  "\x1B[31m"
#define KGRN  "\x1B[32m"
#define KYEL  "\x1B[33m"
#define KBLU  "\x1B[34m"
#define KMAG  "\x1B[35m"
#define KCYN  "\x1B[36m"
#define KWHT  "\x1B[37m"


#define likely(x)      __builtin_expect(!!(x), 1)
#define unlikely(x)    __builtin_expect(!!(x), 0)

#define MAX(a,b) (((a)>(b))?(a):(b))

#include <stdlib.h>
#include <stdint.h>

void xerror(char *msg, int line, char *file);

uint32_t xfilesdir(char *folder);

uint32_t xfilesize(char *file);

void xmemset(void *p, size_t size); 

void *xcalloc(size_t nmemb, size_t size);

void *xmalloc(size_t size); 

#endif
