#ifndef H_bitvector
#define H_bitvector

#include <stdint.h>

#define BYTE 8
#define WORD (sizeof(bitvector)*BYTE)
#define BIT(bv, i) ((bv->B[((i-1)/WORD)] &\
			((bitvector)1 << (WORD-1-((i-1) % WORD)))) > 0)

typedef uint64_t bitvector;

typedef struct {
	bitvector *B;
	uint64_t  N;
	uint64_t  size;
	uint64_t  bits;
	void      *table;
} bitvector_t;

struct succinct_t {
	bitvector_t *restrict B;
	uint64_t i;
};

bitvector_t *bitvector_create(uint64_t bits);

void bitvector_destroy(bitvector_t *restrict bv);

void bitvector_randomize(bitvector_t *restrict bv);

void bitvector_randomize_zero(bitvector_t *restrict bv, uint64_t factor);

void bitvector_print(bitvector_t *restrict bv);

void bitvector_set_bits(bitvector *restrict bv, uint64_t start, 
		uint64_t width, bitvector value);

bitvector bitvector_get_bits(bitvector *restrict bv, uint64_t start, 
		uint64_t width);
#endif
