#define _GNU_SOURCE

#include <stdlib.h>
#include <stdio.h>

#include <string.h>

#include <sys/types.h>
#include <stdint.h> 
#include <errno.h>
#include <assert.h>

#include <papi.h>

#include <time.h>

#include "measure.h"

int *events[18];

__attribute__ ((visibility("default")))
int measure(char *testname, char *testfile, testfunc fp, void *up[], int ups) {
	int res, i, j, timemeasured = 0;
	uint64_t total_ns, total_s;
	struct timespec begin, end;

	long long meas[5] = {0, 0, 0, 0, 0};

	printf("%s,%s", testname, testfile);

	for (i = 0; i < 18; i++) {
		if (!timemeasured) {
			clock_gettime(CLOCK_REALTIME, &begin);
		}

		if ((res = PAPI_start_counters(&events[i][1], events[i][0])) != PAPI_OK) {
			//fprintf(stderr, "Error starting counter: %s\n", PAPI_strerror(res));
			for (j = 1; j <= events[i][0]; j++) {
				printf(",0");
			}
			continue;
		};

		for (j = 0; j < ups; j++) {
			(fp)(up[j]);
		}

		PAPI_stop_counters(meas, events[i][0]);

		if (!timemeasured) {
			clock_gettime(CLOCK_REALTIME, &end);

			if (begin.tv_nsec <= end.tv_nsec) {
				total_ns = end.tv_nsec - begin.tv_nsec;
				total_s  = end.tv_sec  - begin.tv_sec;
			} else {
				total_ns = end.tv_nsec + (1e9 - begin.tv_nsec);
				total_s  = end.tv_sec - begin.tv_sec - 1;
			}

			printf(",%f,%f", (double)total_s/ups, (double)total_ns/ups);
			timemeasured = 1;
		}

		for (j = 1; j <= events[i][0]; j++) {
			printf(",%lld", meas[j-1]/ups);
		}
	}

	printf("\n");

	return 0;
}

__attribute__ ((visibility("default")))
int
measure_init() {
	int i, j;
	char buf[1024];

	for (i = 0; i < 18; i++) {
		events[i] = calloc(sizeof(int), 6);
		if (events[i] == NULL) {
			return 0;
		}
	}

	events[0][0] = 2;
	events[0][1] = PAPI_L1_DCM;
	events[0][2] = PAPI_L1_DCA;

	events[1][0] = 2;
	events[1][1] = PAPI_L1_ICM;
	events[1][2] = PAPI_L1_ICA;

	events[2][0] = 2;
	events[2][1] = PAPI_L1_LDM;
	events[2][2] = PAPI_LD_INS;

	events[3][0] = 2;
	events[3][1] = PAPI_L1_STM;
	events[3][2] = PAPI_SR_INS;

	events[4][0] = 2;
	events[4][1] = PAPI_L2_ICM;
	events[4][2] = PAPI_L2_ICA;

	events[5][0] = 2;
	events[5][1] = PAPI_BR_MSP;
	events[5][2] = PAPI_BR_CN;

	events[6][0] = 2;
	events[6][1] = PAPI_BR_TKN;
	events[6][2] = PAPI_BR_NTK;

	events[7][0] = 2;
	events[7][1] = PAPI_TLB_DM;
	events[7][2] = PAPI_TLB_IM;

	events[8][0] = 1;
	events[8][1] = PAPI_BR_INS;

	events[9][0] = 3;
	events[9][1] = PAPI_RES_STL;
	events[9][2] = PAPI_TOT_CYC;
	events[9][3] = PAPI_REF_CYC;

	events[10][0] = 2;
	events[10][1] = PAPI_TOT_IIS;
	events[10][2] = PAPI_TOT_INS;

	events[11][0] = 1;
	events[11][1] = PAPI_L2_DCM;

	events[12][0] = 1;
	events[12][1] = PAPI_L2_DCA;

	events[13][0] = 2;
	events[13][1] = PAPI_L2_LDM;
	events[13][2] = PAPI_L2_STM;

	events[14][0] = 1;
	events[14][1] = PAPI_L2_TCR;

	events[15][0] = 1;
	events[15][1] = PAPI_L2_TCW;

	events[16][0] = 5;
	events[16][1] = PAPI_L3_DCA;
	events[16][2] = PAPI_L3_DCR;
	events[16][3] = PAPI_L3_LDM;
	events[16][4] = PAPI_L3_TCM;
	events[16][5] = PAPI_L3_DCW;

	events[17][0] = 4;
	events[17][1] = PAPI_L3_ICA;
	events[17][2] = PAPI_L3_ICR;
	events[17][3] = PAPI_L3_TCA;
	events[17][4] = PAPI_L3_TCR;

	int res;

	if ( (res = PAPI_library_init(PAPI_VER_CURRENT)) != PAPI_VER_CURRENT) {
		fprintf(stderr, "Unable to initialize PAPI: %s\n", PAPI_strerror(res));
		return 0;
	}

	printf("Testfile,Testsize,Seconds,Nanoseconds");
	for (i = 0; i < 18; i++) {
		for (j = 1; j <= events[i][0]; j++) {
			PAPI_event_code_to_name(events[i][j], buf);
			printf(",%s", buf);
		}
	}
	printf("\n");

	return 1;
}

__attribute__ ((visibility("default")))
void measure_destroy() {
	int i;
	for (i = 0; i < 18; i++) {
		if (NULL != events[i]) {
			free(events[i]);
		}
	}
	PAPI_shutdown();
}
