#include <inttypes.h>

#include "naive.h"
#include "matrix.h"

// C = AB
// A \in m \times n
// B \in n \times p
// C \in m \times p
//

void mm_naive_mult(matrix_t *restrict A, matrix_t *restrict B, 
		matrix_t *restrict C, uint32_t m, uint32_t n, uint32_t p) {
	uint32_t i, j, k;
	int32_t count = 0;

//#pragma omp parallel for private(i, j, k) schedule(static)
	for (i = 0; i < m ; i++) {
		for (j = 0; j < p ; j++) {
			count = 0;
			for (k = 0; k < n ; k++) {

				count += MAT(A, i, k) * MAT(B, k, j);

			}

			MAT(C, i, j) = count;
		}
	}
}

void naive(struct matrix_mult *restrict str){
	matrix_t *restrict A = str->A;
	matrix_t *restrict B = str->B;
	matrix_t *restrict C = str->C;

	mm_naive_mult(A, B, C, A->m, A->n, B->n);
}
