#include <stdio.h>
#include <stdlib.h>
#include <inttypes.h>
#include <math.h>
#include <string.h>

#include "matrix.h"
#include "xutil.h"

matrix_t *matrix_create(uint32_t m, uint32_t n) {
	int32_t size = m*n*sizeof(int32_t);
	matrix_t *matrix = xmalloc(sizeof(matrix_t));

	matrix->data = xmalloc(size);
	matrix->m = m;
	matrix->n = n;

	matrix_zero(matrix);

	return matrix;
}

void matrix_zero(matrix_t *matrix) {
	memset(matrix->data, '\0', sizeof(int32_t) * matrix->m * matrix->n);
}

void matrix_destroy(matrix_t *matrix) {
	if (matrix != NULL) {
		if (matrix->data != NULL) {
			free(matrix->data);
		}
		free(matrix);
	}
}

void matrix_randomize(matrix_t *matrix, unsigned int seed) {
	uint32_t i, j;
	int32_t max = sqrt((INT32_MAX / matrix->n));

	srand(seed);

	for (i = 0; i < matrix->m ; i++) {
		for (j = 0; j < matrix->n ; j++) {
			MAT(matrix, i, j) = ((rand() % 2) * 2 -1) * (rand() % max);
		}
	}
}
