#define _DEFAULT_SOURCE

#include <stdlib.h>
#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <dirent.h>

#include <sys/stat.h>

#include "xutil.h"

void xerror(char *msg, int line, char *file) {
	fprintf(stderr, "Error %d@%s: %s\n", line, file, msg);
	exit(EXIT_FAILURE);
}

uint32_t xfilesdir(char *folder) {
	DIR *dir;
	struct dirent *entry;
	unsigned int count = 0;	

	if ((dir = opendir(folder)) == NULL) {
		xerror(strerror(errno), __LINE__, __FILE__);
	}

	while ((entry = readdir(dir)) != NULL) {
		if (entry->d_type == DT_REG) { /* If the entry is a regular file */
			count++;
		}
	}

	closedir(dir);

	return count;
}

uint32_t xfilesize(char *file) {
	struct stat buf;
	int r = stat(file, &buf);
	if (r == -1) {
		fprintf(stderr, "Cannot stat '%s': '%s'\n", file, strerror(errno));
		exit(EXIT_FAILURE);
	}

	return buf.st_size;
}

void xmemset(void *p, size_t size) {
	if (p != NULL) {
		memset(p, '\0', size);
	}
}

void *xcalloc(size_t nmemb, size_t size) {
	void *p = calloc(nmemb, size);

	if (p == NULL) {
		fprintf(stderr, "Unable to c-allocate memory.\n");
		exit(EXIT_FAILURE);
	}

	return p;
}

void *xmalloc(size_t size) {
	void *p = malloc(size);

	if (p == NULL) {
		fprintf(stderr, "Unable to m-allocate memory.\n");
		exit(EXIT_FAILURE);
	}

	return p;
}
