#define _DEFAULT_SOURCE

#include <stdlib.h>   /* exit(), calloc(), malloc(), EXIT_FAILURE */
#include <time.h>
#include <stdint.h>   /* uint64_t */
#include <inttypes.h>   /* uint64_t */
#include <stdio.h>    /* fprintf() */
#include <string.h>   /* memset() */
#include <dirent.h>   /* DIR, struct dirent */
#include <errno.h>    /* errno */
#include <sys/stat.h>

#include "xutil.h"

unsigned int I1 = 1234;
unsigned int I2 = 5678;

extern inline double xuni_rand(void);
static struct timespec begin, end;

void start_timer() {
	clock_gettime(CLOCK_REALTIME, &begin);
}

void stop_timer(char *message) {
	uint64_t total_ns, total_s;
	clock_gettime(CLOCK_REALTIME, &end);
	if (begin.tv_nsec <= end.tv_nsec) {
		total_ns = end.tv_nsec - begin.tv_nsec;
		total_s  = end.tv_sec  - begin.tv_sec;
	} else {
		total_ns = end.tv_nsec + (1e9 - begin.tv_nsec);
		total_s  = end.tv_sec - begin.tv_sec - 1;
	}

	uint64_t total = total_s * 1e9 + total_ns;
	printf("%s, %"PRIu64"\n", message, total);
}



void xerror(char *msg, int line, char *file) {
	fprintf(stderr, "Error %d@%s: %s\n", line, file, msg);
	exit(EXIT_FAILURE);
}

uint64_t xfilesize(char *file) {
	struct stat buf;
	int r = stat(file, &buf);

	if (r == -1) {
		xerror(strerror(errno), __LINE__, __FILE__);
	}

	return buf.st_size;
}

uint64_t xfilesdir(char *folder) {
	DIR *dir;
	struct dirent *entry;
	unsigned int count = 0;

	if ((dir = opendir(folder)) == NULL) {
		xerror(strerror(errno), __LINE__, __FILE__);
	}

	while ((entry = readdir(dir)) != NULL) {
		if (entry->d_type == DT_REG) { /* If the entry is a regular file */
			count++;
		}
	}

	closedir(dir);

	return count;
}

void xmemset(void *p, size_t size) {
	if (p != NULL) {
		memset(p, '\0', size);
	}
}

void *xcalloc(size_t nmemb, size_t size) {
	void *p;

	if (size == 0 || nmemb == 0) {
		return NULL;
	}

	p = calloc(nmemb, size);

	if (p == NULL) {
		xerror("Unable to c-allocate memory", __LINE__, __FILE__);
	}

	return p;
}

void *xmalloc(size_t size) {
	void *p;

	if (size == 0) {
		return NULL;
	}

	p = malloc(size);

	if (p == NULL) {
		xerror("Unable to m-allocate memory", __LINE__, __FILE__);
	}

	return p;
}

void *xrealloc(void *ptr, size_t size) {
	void *p;

	if (size == 0) {
		return NULL;
	}

	p = realloc(ptr, size);

	if (p == NULL) {
		xerror("Unable to m-allocate memory", __LINE__, __FILE__);
	}

	return p;
}
