#define _DEFAULT_SOURCE

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "dijkstra.h"
#include "xutil.h"
#include "matrix.h"

matrix_t *read_graph_matrix(char *filename) {
	FILE *fd;
	int res;
	int c = 0;
	uint64_t i, j, n, e, w;
	size_t bufsize = 256;
	char *buf = xmalloc(bufsize);
	matrix_t *matrix;

	fd = fopen(filename, "r");
	if (fd == NULL) {
		xerror("Unable to open input file\n", __LINE__, __FILE__);
	}

	c = getline(&buf, &bufsize, fd);
	res = sscanf(buf, "%"PRIu64"\n", &n);
	if (res != 1) {
		xerror("Unable to read amount of nodes\n", __LINE__, __FILE__);
	}

	c = getline(&buf, &bufsize, fd);
	res = sscanf(buf, "%"PRIu64"\n", &e);
	if (res != 1) {
		xerror("Unable to read amount of edges\n", __LINE__, __FILE__);
	}

	matrix = matrix_create(n, n);

	while ((c = getline(&buf, &bufsize, fd)) != -1) {
		res = sscanf(buf, "%"PRIu64" %"PRIu64" %"PRIu64"\n", &i, &j, &w);
		if (res == 3) {
			MAT(matrix, i, j) = w;
		} else {
			xerror("Unable to read line\n", __LINE__, __FILE__);
		}
	}

	fclose(fd);

	free(buf);
	
	return matrix;
}

Node_t **Dijkstra(struct dijk_measure* d) {
	Node_t *node;
	uint64_t source = d->source;
	heap_t *heap = d->heap;
	matrix_t *graph = d->matrix;
	uint64_t alt, weight;
	uint64_t v, u;
	uint64_t n = graph->n;
	uint64_t *dist = xmalloc(n*sizeof(uint64_t));
	Node_t **prev = xmalloc(n*sizeof(Node_t *));
	Node_t **nodes = xmalloc(n*sizeof(Node_t *));

	heap->heap = heap->create();

	for (v = 0; v < n; v++) {
		dist[v] = INT64_MAX;
		nodes[v] = NULL;
	}

#ifdef TIME
	start_timer();
#endif
	prev[source] = nodes[source] = heap->insert(heap->heap, 0);
#ifdef TIME
	stop_timer("i");
#endif

	nodes[source]->v = source;
	dist[source] = 0;

	// While heap is not empty
	while ( !heap->empty(heap->heap) ) {	
#ifdef TIME
		start_timer();
#endif
		node = heap->deletemin(heap->heap);
#ifdef TIME
		stop_timer("dm");
#endif
		u = node->v;
		for (v = 0; v < n; v++) {
			weight = MAT(graph, u, v);
			if ( likely(v != u) && weight != 0 ) {
				alt = dist[u] + weight;
				if (alt < dist[v]) {
					dist[v] = alt;
					prev[v] = node;
					if (nodes[v] == NULL) {
#ifdef TIME
						start_timer();
#endif
						nodes[v] = heap->insert(heap->heap, alt);
#ifdef TIME
						stop_timer("i");
#endif
						nodes[v]->v = v;
					} else {
#ifdef TIME
						start_timer();
#endif
						heap->decreasekeyto(heap->heap, alt, nodes[v]);
#ifdef TIME
						stop_timer("dk");
#endif
					}
				}
			}
		}
	}

	heap->free(heap->heap);

	free(dist);

	if ( !d->result ) {
		for (v = 0; v < n; v++) {
			if ( NULL != nodes[v] ) {
				free(nodes[v]);
			}
		}

		free(nodes);
		free(prev);
		return NULL;
	}
	d->nodes = nodes;
	return prev;
}

Node_t **Dijkstra2(struct dijk_measure* d) {
	uint64_t source = d->source;
	heap_t *heap = d->heap;
	matrix_t *graph = d->matrix;
	Node_t *node;
	int64_t alt, weight;
	uint64_t v, u;
	uint64_t n = graph->n;
	int64_t *dist = xmalloc(n*sizeof(uint64_t));
	Node_t **prev = xmalloc(n*sizeof(Node_t *));
	Node_t **nodes = xmalloc(n*sizeof(Node_t *));

	heap->heap = heap->create();

	dist[source] = 0;
	for (v = 0; v < n; v++) {
		if ( likely(source != v) ) {
			dist[v] = INT64_MAX;
			prev[v] = NULL;
		}

#ifdef TIME
		start_timer();
#endif
		nodes[v] = heap->insert(heap->heap, dist[v]);
#ifdef TIME
		stop_timer("i");
#endif
		nodes[v]->v = v;
	}

	prev[source] = nodes[source];

	// While heap is not empty
	while ( !heap->empty(heap->heap) ) {	
#ifdef TIME
		start_timer();
#endif
		node = heap->deletemin(heap->heap);
#ifdef TIME
		stop_timer("dm");
#endif
		u = node->v;
		for (v = 0; v < n; v++) {
			weight = MAT(graph, u, v);
			if ( likely(v != u) && weight != 0 ) {
				alt = dist[u] + weight;
				if (alt < dist[v]) {
					dist[v] = alt;
					prev[v] = node;
#ifdef TIME
					start_timer();
#endif
					heap->decreasekeyto(heap->heap, alt, nodes[v]);
#ifdef TIME
					stop_timer("dk");
#endif
				}
			}
		}
	}

	heap->free(heap->heap);

	free(dist);

	if ( !d->result ) {
		for (v = 0; v < n; v++) {
			if ( NULL != nodes[v] ) {
				free(nodes[v]);
			}
		}

		free(nodes);
		free(prev);
		return NULL;
	}
	d->nodes = nodes;
	return prev;
}
