#!/usr/bin/env python3

import argparse, math
from random import random, shuffle, randrange

def random_graph(n, p):
    G = [0 for i in range(n * n)]

    idx = 0
    e   = 0 # edges
    while True:
        step = math.floor(math.log(random())/math.log(1 - p))
        idx += step

        if idx >= n*n:
            break

        G[idx] = int(20000000 * random()) + 10
        e   += 1

        idx += 1

    return (G, e)

def first_vist_best_graph(n, p):
    nsq = int(math.pow(n, 2))
    G = [0 for i in range(nsq)]

    missing = []
    for i in range(n - 1):
        missing.append(i + 1)

    shuffle(missing)

    added = []

    head = set()
    head.add(0)

    val = 0
    loop = True

    while loop:
        temp = []
        old  = []
        if len(missing) == 0:
            break

        for v in head:
            old.append(v)
            if len(missing) == 0:
                break

            first = missing.pop()
            temp.append(first)
            G[v * n + first] = int(90 * random()) + 10

            while True:
                if len(missing) == 0:
                    break

                if random() > p:
                    break

                next_vertice = missing.pop()
                G[v * n + next_vertice] = int(90 * random()) + 10

                if random() < p:
                    temp.append(next_vertice)

        for v in old:
            head.remove(v)

        for v in temp:
            head.add(v)

    return (G, n - 1)

def last_visit_best_graph(n, p):
    nsq = int(math.pow(n, 2))
    G = [0 for i in range(nsq)]

    missing = []
    for i in range(n - 1):
        missing.append(i + 1)

    shuffle(missing)

    # For each node there should be one node where the transit cost is 10
    # The rest should cost (max - chainlength * 20)

    loop = True
    cur = 0
    max_weight = n * 100
    chain_length = 0
    edges = 0
    while loop:
        next_vertice = missing.pop()

        G[cur * n + next_vertice] = 10
        edges += 1
        for v in missing:
            G[cur * n + v] = max_weight - chain_length * 20
            edges += 1

        cur = next_vertice
        chain_length += 1

        if len(missing) == 0:
            break

    return (G, edges)

def main(args):
    n = args.n
    p = args.p

    if args.t == 'rand':
        (G, e) = random_graph(n, p)
    elif args.t == 'chain':
        (G, e) = first_vist_best_graph(n, p)
    elif args.t == 'best':
        (G, e) = last_visit_best_graph(n, p)

    print(n)
    print(e)

    for i in range(n):
        for j in range(n):
            if G[n * i + j] > 0:
                print(i, j, G[n * i + j])

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('-n', type=int, default=100)
    parser.add_argument('-p', type=float, default=0.3)
    parser.add_argument('-t', choices=['rand', 'chain', 'best'], default='rand')
    args = parser.parse_args()
    try:
        main(args)
    except KeyboardInterrupt:
        pass
