#!/usr/bin/env python3

import argparse
from random import random
from collections import namedtuple
from math import floor, ceil
from heapq import heappush, heappop
from enum import Enum

Node = namedtuple('Node', ['k', 'i'], verbose=False)

class Workload:
    def __init__(self, N):
        self.exists  = []
        self.heap    = []
        self.mapping = []

        self.values  = set()

        self.nodes   = []
        self.missing = [i for i in range(N)]

        self.index  = 0
        self.len    = 0

        self.N = N

        #self.insert(0)

    def insert(self, key = None):
        self.len += 1

        if key == None:
            while True:
                key = int(1000000 + random() * 500000)
                if key not in self.values:
                    break

        index = self.index
        self.index += 1

        self.exists.append(1)
        self.mapping.append(len(self.nodes))

        node = Node(key, index)

        self.values.add(key)
        self.nodes.append(node)

        heappush(self.heap, node)
        self.missing.pop()
        print("Insert({})".format(key))

    def decreasekey(self):
        index = floor(random() * (len(self.nodes) + len(self.missing)))
        #print("Index:", index, "Nodes:", len(self.nodes), "Missing:", len(self.missing))

        if len(self.missing) > 0 and (len(self.nodes) == 0 or index >= len(self.nodes)):
            # Select from missing => insert
            self.insert()
        else:
            # Select from nodes => decrease_key
            #print(len(self.nodes), index)
            node = self.nodes[index]

            while True:
                decrease_by = int(10000 + random() * 10000)
                if node.k - decrease_by not in self.values:
                    break

            self.values.remove(node.k)
            self.values.add(node.k - decrease_by)

            node = node._replace(k=node.k - decrease_by)
            self.nodes[index] = node
            heappush(self.heap, node)
            print("DecreaseKey({}, {})".format(decrease_by, node.i))

    def deletemin(self):
        while True:
            node = heappop(self.heap)
            if self.exists[node.i] == 1:
                break

        self.len -= 1

        index = self.mapping[node.i]
        self.exists[node.i] = 0
        last_index = len(self.nodes) - 1

        #print("DEB; Popping: {}".format(node.i))
        #print("DEB; Value:   {}".format(node.k))
        #print("Index: {}, Last_index:{}".format(index, last_index))
        if index == last_index:
            node = self.nodes.pop()
        else:
            node = self.nodes[index]
            new = self.nodes.pop()
            #print("Updating index of element {} to {}".format(new.i, index))
            self.nodes[index] = new
            self.mapping[new.i] = index

        self.values.remove(node.k)

        print("DeleteMin()")

    def __len__(self):
        return self.len

class Op(Enum):
    insert      = 1
    decreasekey = 2
    deletemin   = 3

def main(N, epsilon):
    # N nodes
    # max N^2 decrease-key calls
    # N delemins

    f_insert = 0.5
    f_deletemin = 0.25
    f_decreasekey = 0.25


    frac = N/pow(N, 1 + epsilon)


    w = Workload(N)

    deletes  = 0
    while True:
        if len(w) > 0 and random() < frac:
            #print("Deletes:", deletes)
            w.deletemin()
            deletes += 1
        else:
            w.decreasekey()

        if deletes == N:
            break

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('-n', type=int, help='Number of vertices', default = 10)
    parser.add_argument('-e', type=float, help='About N^(1+e) decreasekeys', default = 0.2)

    args = parser.parse_args()
    main(args.n, args.e)
