#include <stdint.h>
#include <gmp.h>

#ifndef STREAMS
#define STREAMS

typedef void (*writer_t)(int i, uint32_t v);
typedef void (*closer_t)(int i);
typedef void (*setbuffer_t)(int id, int B, uint32_t *buf);
typedef void (*seek_in_t)(int i, long offset, int length);
typedef void (*seek_out_t)(int i, long offset, int length);
typedef uint32_t (*reader_t)(int i);
typedef int (*eoser_t)(int i);

typedef int (*opener_t)(char *f, uint64_t start, uint64_t length, int B, 
		int flag);
typedef int (*creater_t)(char *f, uint64_t start, uint64_t length, int B,
		int flag);

typedef struct {
	reader_t    next;
	reader_t    last;
	eoser_t     eos;
	closer_t    close;
	opener_t    open;
	setbuffer_t setbuffer;
	seek_in_t   seek;
} in_stream;

typedef struct {
	writer_t    write;
	writer_t    prepend;
	closer_t    close;
	creater_t   create;
	setbuffer_t setbuffer;
	seek_out_t      seek;
} out_stream;

enum {
	STREAM_FORWARDS,
	STREAM_BACKWARDS
};

// Memory allocation functions.
void *xcalloc(size_t nmemb, size_t size);
void *xmalloc(size_t size);
void *xrealloc(void *ptr, size_t size);

// Implementation of part A using read() and write() system calls.
int i_open(const char *f, uint64_t start, uint64_t length);
uint32_t i_next(int id);
int i_eos(int id);
void i_close(int id);

int o_create(const char *f, uint64_t start);
void o_write(int od, uint32_t v);
void o_close(int od);

// Implementation of part B using fread() and fwrite() library calls.
int fi_open(const char *restrict f, uint64_t start, uint64_t length, int B, int dir);
uint32_t fi_next(int id);
uint32_t fi_last(int id);
int fi_eos(int id);
void fi_close(int id);
void fi_setbuffer(int id, int B, uint32_t *buf);
void fi_seek(int id, long offset, int length);

int fo_create(const char *restrict f, uint64_t start, int B, int dir);
void fo_write(int od, uint32_t v);
void fo_prepend(int od, uint32_t v);
void fo_close(int od);
void fo_setbuffer(int od, int B, uint32_t *buf);
void fo_seek(int od, long offset, int length);

// Implementation of part C using part A with buffers.
int bi_open(const char *restrict f, uint64_t start, uint64_t length, int B, int dir);
uint32_t bi_next(int id);
int bi_eos(int id);
void bi_close(int id);
void bi_setbuffer(int id, int B, uint32_t *buf);
void bi_seek(int id, long offset, int length);
uint32_t bi_last(int id);

int bo_create(const char *restrict f, uint64_t start, int B, int dir);
void bo_write(int od, uint32_t v);
void bo_close(int od);
void bo_setbuffer(int od, int B, uint32_t *buf);
void bo_seek(int od, long offset);
void bo_prepend(int od, uint32_t v);

// Implementation of part D using mmap.
int mi_open(const char *f, uint64_t start, uint64_t length, int B, int dir);
uint32_t mi_next(int id);
uint32_t mi_last(int id);
int mi_eos(int id);
void mi_close(int id);
void mi_seek(int id, long offset, int length);

int mo_create(const char *f, uint64_t start, uint64_t length, int B, int dir);
void mo_write(int od, uint32_t v);
void mo_prepend(int od, uint32_t v);
void mo_close(int od);
void mo_seek(int od, long offset, int length);

#endif
