#include "streams.h"
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

const int DEFAULT_START_LENGTH = 10;

int errorAndDie(int pos) {
	fprintf(stderr, "Error at %d: %s\n", pos, strerror(errno));
	exit(EXIT_FAILURE);
}

int stream_find_struct_storage(uintptr_t **p, int *len) {
	int id = 0, i;

	if(*len == 0) {

		(*p) = xcalloc(sizeof(uintptr_t*), DEFAULT_START_LENGTH);
		*len = 10;

		for(i = 0; i < (*len); i++) {
			(*p)[i] = 0;
		}

		id = 0;

	} else {

		for(i = 0; i < (*len); i++) {
			if((*p)[i] == 0) {
				id = i;
				break;
			}
		}

		if(i > 0 && id == 0) {
			*p = xrealloc(*p, sizeof(uintptr_t*) * 2 * (*len) );
			id  = (*len);

			for(i = id; i < 2 * (*len); i++) {
				(*p)[i] = 0;
			}

			(*len) *= 2;
		}
	}

	return id;
}
