#define _XOPEN_SOURCE 700

#include "streams.h"
#include "bbs.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <errno.h>
#include <unistd.h>
#include <getopt.h>
#include <string.h>
#include <stdbool.h>
#include <sys/time.h>
#include <time.h>
#include <sys/resource.h>

/*
 * TODO:
 * Prøv med forskellige flags på mmap.
 * 	- MAP_POPULATE
 *
 */

static char *TempFile = "file";

static int N_DEFAULT = 20;
static int B_DEFAULT = 1024;
static int K_DEFAULT = 4;
static int S_DEFAULT = 1; 		// A
static int T_DEFAULT = 0; 		// Write
static char *D_DEFAULT = "tmp";

static int  offset = 0;             // Offset
static bool reverse = false;   // Write backwards?


void testWrite(int o, bbs_t *bbs_state, writer_t writer) {
	uint32_t v;

	v = bbs(bbs_state);
	writer(o, v);
	//printf("%u\n", v);
}

void testRead(int i, reader_t reader, eoser_t eos) {
	//uint32_t v;

	if (!eos(i)) {
		reader(i);
		//printf("%u\n", v);
	}
}

void printUsage(char **argv) {
	fprintf(stderr, "Usage: %s \n"
			"\t[-N #samples]\n"
			"\t[-B buffer size]\n"
			"\t[-k #streams]\n"
			"\t[-S stream implementation (1-4 = A-D)]\n"
			"\t[-t read (r) or write (w, default)]\n"
			"\t[-r reverse reading direction]\n"
			"\t[-o specify offset into file)]\n"
			"\t[-D folder to place files in, default = tmp, must exist!, max 200 chars]\n"
			, argv[0]);
}

void performRead(int N, int B, int k, int S, char *file) {
	int i, n;
	char buf[100];
	int in[k];
	eoser_t eoser   = NULL;
	reader_t reader = NULL;
	closer_t closer = NULL;

	// Create the streams
	if (S == 1) {
		for (i=0; i<k; i++) {
			sprintf(buf, "%s%d", file, i);
			in[i] = i_open(buf, 0, N);
		}

		eoser = i_eos;
		reader = i_next;
		closer = i_close;
	} else if (S == 2) {
		for (i=0; i<k; i++) {
			sprintf(buf, "%s%d", file, i);
			int dir = reverse ? STREAM_BACKWARDS : STREAM_FORWARDS;
			int start = (reverse ? N : 0) + offset;
			in[i] = fi_open(buf, start, N, B, dir);
		}

		eoser = fi_eos;
		reader = reverse ? fi_last : fi_next;
		closer = fi_close;
	} else if (S == 3) {
		for (i=0; i<k; i++) {
			sprintf(buf, "%s%d", file, i);
			int dir = reverse ? STREAM_BACKWARDS : STREAM_FORWARDS;
			int start = (reverse ? N : 0) + offset;
			in[i] = bi_open(buf, start, N, B, dir);
		}

		eoser = bi_eos;
		reader = reverse ? bi_last : bi_next;
		closer = bi_close;
	} else if (S == 4) {
		for (i=0; i<k; i++) {
			sprintf(buf, "%s%d", file, i);
			int dir = reverse ? STREAM_BACKWARDS : STREAM_FORWARDS;
			int start = (reverse ? N : 0) + offset;
			in[i] = mi_open(buf, start, N, B, dir);
		}

		eoser = mi_eos;
		reader = reverse ? mi_last : mi_next;
		closer = mi_close;
	}

	for (n=0; n<N; n++) {
		for (i=0; i<k; i++) {
			testRead(in[i], reader, eoser);
		}
	}

	for (i=0; i<k; i++) {
		closer(in[i]);
	}

	(void)S;
}

void performWrite(int N, int B, int k, int S, char *file) {
	int i, n;
	char buf[100];
	int out[k];
	bbs_t *bbs_state[k];
	writer_t writer = NULL;
	closer_t closer = NULL;

	// Initialize number generator
	for (i=0; i<k; i++) {
		bbs_state[i] = init_bbs(104399, 47507, 68207);
	}

	// Create the streams
	if (S == 1) {
		for (i=0; i<k; i++) {
			sprintf(buf, "%s%d", file, i);
			out[i] = o_create(buf, 0);
		}

		writer = o_write;
		closer = o_close;
	} else if (S == 2) {
		for (i=0; i<k; i++) {
			sprintf(buf, "%s%d", file, i);
			int dir = reverse ? STREAM_BACKWARDS : STREAM_FORWARDS;
			int start = (reverse ? N : 0) + offset;
			out[i] = fo_create(buf, start, B, dir);
		}

		writer = reverse ? fo_prepend : fo_write;
		closer = fo_close;
	} else if (S == 3) {
		for (i=0; i<k; i++) {
			sprintf(buf, "%s%d", file, i);
			int dir = reverse ? STREAM_BACKWARDS : STREAM_FORWARDS;
			int start = (reverse ? N : 0) + offset;
			out[i] = bo_create(buf, start, B, dir);
		}

		writer = reverse ? bo_prepend : bo_write;
		closer = bo_close;
	} else if (S == 4) {
		for (i=0; i<k; i++) {
			sprintf(buf, "%s%d", file, i);
			int dir = reverse ? STREAM_BACKWARDS : STREAM_FORWARDS;
			int start = (reverse ? N : 0) + offset;
			out[i] = mo_create(buf, start, N, B, dir);
		}

		writer = reverse ? mo_prepend : mo_write;
		closer = mo_close;
	}

	// Write to the streams
	for (n=0; n<N; n++) {
		for (i=0; i<k; i++) {
			testWrite(out[i], bbs_state[i], writer);
		}
	}

	// Close the streams and free the number generator
	for (i=0; i<k; i++) {
		closer(out[i]);

		free_bbs(bbs_state[i]);
	}
}

int main (int argc, char **argv) {
	struct timespec begin;
	struct timespec end;

	// Store when the program began running.
	clock_gettime(CLOCK_REALTIME, &begin);
	int total_ns;
	int total_s;

	int r, opt, 
		N = N_DEFAULT, 
		B = B_DEFAULT,
		k = K_DEFAULT,
		S = S_DEFAULT,
		t = T_DEFAULT;

	char *D,
		 file[255];
	struct rusage usage;
	char c;

	D = strndup(D_DEFAULT, 200);

	while ((opt = getopt(argc, argv, "N:B:k:S:t:D:o:r")) != -1) {
		switch (opt) {
		case 'N':
			N = strtol(optarg, NULL, 10);
			break;
		case 'B':
			B = strtol(optarg, NULL, 10);
			break;
		case 'k':
			k = strtol(optarg, NULL, 10);
			break;
		case 'S':
			S = strtol(optarg, NULL, 10);
			break;
		case 'o':
			offset = strtol(optarg, NULL, 10);
			break;
		case 'r':
			reverse = true;
			break;
		case 'D':
			free(D);
			D = strndup(optarg, 200);
			break;
		case 't':
			if (strnlen(optarg, 2) != 1) {
				fprintf(stderr, "Bad argument length of -t\n\n");
				printUsage(argv);
				exit(EXIT_FAILURE);
			} else if (strncmp(optarg, "w", 1) == 0) {
				t = 0;
			} else if (strncmp(optarg, "r", 1) == 0) {
				t = 1;
			} else {
				fprintf(stderr, "Unknown argument to -t\n\n");
				printUsage(argv);
				exit(EXIT_FAILURE);
			}
			break;
		default:
			printUsage(argv);
			exit(EXIT_FAILURE);
		}
	}

	sprintf(file, "%s/%s", D, TempFile);

	free(D);

	if (S < 1 || S > 4) {
		fprintf(stderr, "Wrong usage of -S\n\n");
		printUsage(argv);
		exit(EXIT_FAILURE);
	}


	if (t == 0) { // t START
		performWrite(N, B, k, S, file);
	} else {
		performRead(N, B, k, S, file);
	}

	r = getrusage(RUSAGE_SELF, &usage);

	if (r == -1) {
		printf("Unable to get usage data: '%s'\n", strerror(errno));
		exit(EXIT_FAILURE);
	}

	if (t == 0) {
		c = 'W';
	} else {
		c = 'R';
	}

	clock_gettime(CLOCK_REALTIME, &end);

	if (begin.tv_nsec <= end.tv_nsec) {
		total_ns = end.tv_nsec - begin.tv_nsec;
		total_s  = end.tv_sec  - begin.tv_sec;
	} else {
		total_ns = end.tv_nsec + (1e9 - begin.tv_nsec);
		total_s  = end.tv_sec - begin.tv_sec - 1;
	}

	printf(
		"%c,%d,%d,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld\n",
			c,
			/* Total realworld seconds/nsec used */
			total_s,
			total_ns,
			/* Total amount of CPU user time used.  */
			usage.ru_utime.tv_sec,   // Seconds
			usage.ru_utime.tv_usec,  // Microseconds
			/* Total amount of CPU system time used.  */
			usage.ru_stime.tv_sec,   // Seconds
			usage.ru_stime.tv_usec,  // Microseconds
			/* Maximum resident set size (in kilobytes).  */
			usage.ru_maxrss,
			/* Amount of data segment memory used (kilobyte-seconds).  */
			usage.ru_idrss,
			/* Amount of stack memory used (kilobyte-seconds).  */
			usage.ru_isrss,
			/* Number of soft page faults (i.e. those serviced by reclaiming
			   a page from the list of pages awaiting reallocation.  */
			usage.ru_minflt,
			/* Number of hard page faults (i.e. those that required I/O).  */
			usage.ru_majflt,
			/* Number of times a process was swapped out of physical memory. */
			usage.ru_nswap,
			/* Number of input operations via the file system.  Note: This
			   and `ru_oublock' do not include operations with the cache.  */
			usage.ru_inblock,
			/* Number of output operations via the file system.  */
			usage.ru_oublock,
			/* Number of voluntary context switches, i.e. because the process
			   gave up the process before it had to (usually to wait for some
			   resource to be available).  */
			usage.ru_nvcsw,
			/* Number of involuntary context switches, i.e. a higher priority
			 * process became runnable or the current process used up its time
			 * slice. */
			usage.ru_nivcsw
		);


	exit(EXIT_SUCCESS);
}
