typedef struct bbs {
	mpz_t *x;
	mpz_t *M;
} bbs_t;

/* Initialize the Blum Blum Shub random number generator:
 * http://en.wikipedia.org/wiki/Blum_Blum_Shub
 * */
bbs_t *init_bbs(int x0, int p, int q);

/* Get the next random number for the generator */
unsigned int bbs(bbs_t *state);

/* Clear the storage used by the random number generator */
void free_bbs(bbs_t *state);
