#!/usr/bin/env bash
EXE=heap
REPEAT_COUNT=2  # Times we repeat each test
TESTMAX=84    # Maximal number of tests
RESULTS_FOLDER=PmTEST_RESULTS
TMP_FOLDER=tmp

DEBUG="1"

# TODO:
# - Check if buffer size is above write/read size?
# - Switch around repetitions, so they are outside.

REPETITION=0
TEST=0

## DEFAULTS START
declare -a Prange=(0)
declare -a mrange=(0)
## DEFAULTS END

PARAM_PRESENT=0

HOST=`hostname | awk -F. '{print $1}'`


Pbase=524288
mbase=115

#                  512KiB 1024KiB 1536KiB 2048KiB
declare -a Prange=(524288 1048576 1572864 2097152)
declare -a mrange=(115    231     347     663)

# Streams we want to test
declare -a Streams=(3 4);


# Files we try to sort
declare -a Files=("TEST640" "TEST1280" "TEST1920" "TEST2560" "TEST3840" "TEST5120")

function reportProgress() {
        curl monitor.dat7.dk --data "{\"machine\": \"${HOST}\", \"iteration\": ${1},\
                \"iteration_max\": ${2}, \"description\": \"$3\"}" -X POST -H\
                "Content-Type: application/json" --silent -o /dev/null
}

trap "tput cvvis; echo \"\"; reportProgress 1 1 Stopped; exit" INT QUIT

function clearCaches() {
	if [[ ${UID} -eq 0 ]]; then
		echo 3 > /proc/sys/vm/drop_caches
		blockdev --flushbufs /dev/sda
		sync
	else
		echo "NOT ROOOOOOOT!"
	fi
}

function clearTmp() {
	if [[ ${DEBUG} != "1" ]]; then
		rm -f hstore*.heap
	fi
}

function performTest() {
	local S=$1
	local file=$2
	local P=$3
	local m=$4

	# Clear the lines for output
	echo -en "\r"
	tput el

	printf "Performing iteration %d/%d of test %d/%d\n" ${REPETITION} \
		${REPEAT_COUNT} ${TEST} ${TESTMAX}

	reportProgress ${TCOUNT} \
		$(( ${REPEAT_COUNT} * ${TESTMAX} )) "PmTest: ${file}: S=${S} P=${P} m=${m}"

	# Where we save our data.
	OUTFILE="${RESULTS_FOLDER}/Pmtest.${S}.${file}.${P}.${m}.csv"

	if [[ ${DEBUG} != "1" ]]; then
			./${EXE} -S ${S} -i ${file} -P ${P} -m ${m} -r >> ${OUTFILE};
	else
		echo "./${EXE} -S ${S} -i ${file} -P ${P} -m ${m} -r";
		#sleep 0.9
	fi
}

function testWrapper() {
	local S=$1
	local file=$2
	local P=$3
	local m=$4

	clearTmp
	performTest ${S} ${file} ${P} ${m}
	clearCaches
}

TESTMAX=$(( ${#Files[@]} * ${#Streams[@]} * (${#Prange[@]} + ${#mrange[@]}) ))
#echo $LEN
#exit

tput civis
mkdir -p ${RESULTS_FOLDER}

echo ""

FCOUNT=0;
TCOUNT=0;
for file in ${Files[@]}; do
	REPETITION=0
	for r in `seq 1 ${REPEAT_COUNT}`; do
		TEST=$(( (${FCOUNT}) * ${#Streams[@]} * (${#Prange[@]} + ${#mrange[@]}) ))
		REPETITION=$(( ${REPETITION} + 1 ))
		for S in ${Streams[@]}; do
			for m in ${mrange[@]}; do
				TEST=$(( ${TEST} + 1 ));
				TCOUNT=$(( ${TCOUNT} + 1 ))
				testWrapper ${S} ${file} ${Pbase} ${m}
			done

			for P in ${Prange[@]}; do
				TEST=$(( ${TEST} + 1 ));
				TCOUNT=$(( ${TCOUNT} + 1 ))
				testWrapper ${S} ${file} ${P} ${mbase}
			done
		done
	done
	FCOUNT=$(( ${FCOUNT} + 1 ))
done

tput cvvis
echo ""
