#define _DEFAULT_SOURCE
#define _BSD_SOURCE

#include <stdlib.h>
#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <getopt.h>
#include <time.h> 
#include <sys/mman.h>
#include <sys/sysinfo.h>	
#include <sys/resource.h> 
#include <sys/types.h>
#include <sys/wait.h>

void *xmalloc(size_t size) {
	void *p = malloc(size);

	if (p == NULL) {
		fprintf(stderr, "Unable to m-allocate memory.");
		exit(EXIT_FAILURE);
	}

	return p;
}

int main(int argc, char* argv[]) {
	int pid, r, j;
	int total_ns;
	int total_s;
	struct sysinfo si;
	struct rusage usage;
	struct timespec begin;
	struct timespec end;
	uint64_t size, i;
	uint64_t M = 230686720; 
	int64_t pagesize;
	char *ptr;
	char **new_argv = xmalloc(sizeof(char *)*(argc));

	if (argc < 2) {
		fprintf(stderr, "memlock should receive at least one argument.\n");
		exit(EXIT_FAILURE);
	}

	r = system("echo 3 > /proc/sys/vm/drop_caches");
	if (r < 0) {
		fprintf(stderr, "Error dropping caches");
		exit(EXIT_FAILURE);
	}
	r = system("blockdev --flushbufs /dev/sda");
	if (r < 0) {
		fprintf(stderr, "Error flushing buffers");
		exit(EXIT_FAILURE);
	}
	r = system("sync");                                                         
	if (r < 0) {
		fprintf(stderr, "Error syncing");
		exit(EXIT_FAILURE);
	}

	r = sysinfo(&si);

	if (r < 0) {	
		fprintf(stderr, "Error when requesting sysinfo: %s\n", strerror(r));
		exit(EXIT_FAILURE);
	}

	pagesize = sysconf(_SC_PAGESIZE);

	if (pagesize < 0) {	
		fprintf(stderr, "Error when requesting pagesize: %s\n", strerror(r));
		exit(EXIT_FAILURE);
	}

	size = (si.freeram+si.bufferram+si.sharedram) - M;

	ptr = xmalloc(size);

	r = mlock(ptr, size);

	if (r < 0) {	
		free(ptr);
		fprintf(stderr, "Error when using mlock: %s\n", strerror(r));
		exit(EXIT_FAILURE);
	}

	for (i = 0; i < size; i += pagesize) {
		ptr[i] = 0;
	}

	for (j = 1; j < argc; j++) {
		new_argv[j-1] = argv[j];
	}
	new_argv[argc-1] = NULL;


	pid = fork();
	if (pid == 0) {
		r = execve(new_argv[0], new_argv, NULL);
		if (r < 0) {
			fprintf(stderr, "Error when using execve: %s\n", strerror(r));
			exit(EXIT_FAILURE);
		}
		return EXIT_SUCCESS;
	} else {
		clock_gettime(CLOCK_REALTIME, &begin);

		wait4(pid, NULL, 0, &usage);

		clock_gettime(CLOCK_REALTIME, &end);

		if (begin.tv_nsec <= end.tv_nsec) {
			total_ns = end.tv_nsec - begin.tv_nsec;
			total_s  = end.tv_sec  - begin.tv_sec;
		} else {
			total_ns = end.tv_nsec + (1e9 - begin.tv_nsec);
			total_s  = end.tv_sec - begin.tv_sec - 1;
		}
	}
	// Run program

	r = munlock(ptr, size);	

	free(new_argv);
	free(ptr);
	
	if (r < 0) {	
		fprintf(stderr, "Error when using mlock: %s\n", strerror(r));
		exit(EXIT_FAILURE);
	}

	printf(
		"%d,%d,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%ld\n",
			/* Total realworld seconds/nsec used */
			total_s,
			total_ns,
			/* Total amount of CPU user time used.  */
			usage.ru_utime.tv_sec,   // Seconds
			usage.ru_utime.tv_usec,  // Microseconds
			/* Total amount of CPU system time used.  */
			usage.ru_stime.tv_sec,   // Seconds
			usage.ru_stime.tv_usec,  // Microseconds
			/* Maximum resident set size (in kilobytes).  */
			usage.ru_maxrss,
			/* Amount of data segment memory used (kilobyte-seconds).  */
			usage.ru_idrss,
			/* Amount of stack memory used (kilobyte-seconds).  */
			usage.ru_isrss,
			/* Number of soft page faults (i.e. those serviced by reclaiming
			   a page from the list of pages awaiting reallocation.  */
			usage.ru_minflt,
			/* Number of hard page faults (i.e. those that required I/O).  */
			usage.ru_majflt,
			/* Number of times a process was swapped out of physical memory. */
			usage.ru_nswap,
			/* Number of input operations via the file system.  Note: This
			   and `ru_oublock' do not include operations with the cache.  */
			usage.ru_inblock,
			/* Number of output operations via the file system.  */
			usage.ru_oublock,
			/* Number of voluntary context switches, i.e. because the process
			   gave up the process before it had to (usually to wait for some
			   resource to be available).  */
			usage.ru_nvcsw,
			/* Number of involuntary context switches, i.e. a higher priority
			 * process became runnable or the current process used up its time
			 * slice. */
			usage.ru_nivcsw
		);

	return EXIT_SUCCESS;
}
