#define _DEFAULT_SOURCE
#define _GNU_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <inttypes.h>
#include <streams.h>
#include <string.h>
#include <time.h>
#include <getopt.h>
#include <sys/resource.h>
#include <assert.h>

#include "../utilities.h"
#include "../heap.h"

int STREAM_TYPE = 3;
int BUFFER = 4096;
int FANOUT = 0;
int PAGE_SIZE = 0;

// Default memory we save for the stack, 8MiB.
static uint64_t stack_reserved = 8388608;

void printusage(char *argv[]) {
	fprintf(stderr, "Usage: %s \n"
			"\t[-M memory size]\n"
			"\t[-m fanout]\n"
			"\t[-B buffer size]\n"
			"\t[-P page size]\n"
			"\t[-S stream implementation (1-4 = A-D)]\n"
			"\t[-i inputfile]\n"
			, argv[0]);
}

int main(int argc, char *argv[]) {
	char *inputfile = strndup("TEST1", 5);
	char *outputfile = "sorted.out";
	int opt;
	int fd;
	uint64_t N;
	uint64_t i;
	in_stream in;
	out_stream out;

	// Default memory size 104857600 = 100MiB.
	uint64_t M = 104857600;

	while ((opt = getopt(argc, argv, "M:m:B:P:S:i:")) != -1) {
		switch (opt) {
			case 'M':
				M = strtoull(optarg, NULL, 10);
				break;
			case 'm':
				FANOUT = strtoull(optarg, NULL, 10);
				break;
			case 'B':
				BUFFER = strtol(optarg, NULL, 10);
				break;
			case 'P':
				PAGE_SIZE = strtol(optarg, NULL, 10);
				break;
			case 'S':
				STREAM_TYPE = strtol(optarg, NULL, 10);
				if(STREAM_TYPE > 4 || STREAM_TYPE < 1) {
					printusage(argv);
					exit(EXIT_FAILURE);
				}
				break;
			case 'i':
				free(inputfile);
				inputfile = strndup(optarg, 200);
				break;
			default:
				printusage(argv);
				exit(EXIT_FAILURE);
		}
	}

	N = filesize(inputfile)/sizeof(uint32_t);

	init_input_stream(&in);
	init_output_stream(&out);

	external_heap_t *h = heap_init(stack_reserved, M, &in, &out);

	fd = in.open(inputfile, 0, N, BUFFER, STREAM_FORWARDS);
	free(inputfile);
	while ( !in.eos(fd) ) {
		heap_insert(h, in.next(fd));
	}
	in.close(fd);

	fd = out.create(outputfile, 0, N, BUFFER, STREAM_FORWARDS);
//	uint32_t j = 0;
//	uint32_t el;
	for (i = 0; i < N; i++) {
//		el = heap_delete_min(h);

//		if (el != j) {
//			printf("%"PRIu32"!=%"PRIu32"\n", el, j);
//		}
//		assert(el == j);
		out.write(fd, heap_delete_min(h));
//		if (i % 5 == 0) {
//			j++;
//		}
	}
	out.close(fd);

	heap_destroy(h);

	return EXIT_SUCCESS;
}
