#include <stdint.h>
#include "internal_heap.h"

typedef struct {
	// (Static) Variables that define the structure of our heap.
	unsigned int P;
	uint64_t M;
	unsigned int m;
	unsigned int F;
	unsigned int node_size;        // Counted in uint32_t.
	unsigned int node_header_size; // Counted in uint32_t.

	// Storage in global memory.
	uint32_t *m_buffer;
	internal_heap_t *i_buffer;
	uint32_t *r_buffer;

	// Variables changed during runtime.
	unsigned int last_leaf;
	unsigned int last_leaf_length;  // Counted in uint32_t.
	unsigned int root_length;
	unsigned int root_buffer_length;

	// Count of elements in heap
	uint64_t count;

	// Function pointers for streams
	in_stream *in;
	out_stream *out; 
} external_heap_t;

void error(char *msg, int line, char *file);

//////////////////
uint64_t get_file_offset_from_node(external_heap_t *h, unsigned int k);
char *get_file_from_node(unsigned int k);
uint32_t get_node_length(external_heap_t *h, unsigned int k);
/////////////////

external_heap_t *heap_init (uint64_t mem_reserved, uint64_t mem_size, 
		in_stream *in, out_stream *out);
void heap_destroy(external_heap_t *h);

void heap_insert(external_heap_t *h, uint32_t v);
uint32_t heap_delete_min(external_heap_t *h);
