class CreateCompanies < ActiveRecord::Migration[5.1]
  def self.up
    create_table :companies do |t|
      t.string :name
      t.string :address
      t.string :city
      t.string :country
      t.string :phone
      t.integer :cvr, unique: true
      t.timestamps null: false
    end

    add_index "companies", "cvr", unique: true
  end

  def self.down
    drop_table :companies
  end
end
